using System;

namespace Implab
{
    public struct RejectedPromise<T> : IPromise<T> {
        readonly Exception m_reason;

        public Type ResultType => typeof(void);

        public bool IsResolved => true;

        public bool IsRejected => true;

        public bool IsFulfilled => false;

        public Exception RejectReason => m_reason;

        public RejectedPromise(Exception reason) {
            m_reason = reason;
        }

        public IPromise<T2> Cast<T2>() {
            return (IPromise<T2>)(IPromise<T>)this;
        }

        void IPromise.Join() {
            m_reason.ThrowInvocationException();
        }

        void IPromise.Join(int timeout) {
            m_reason.ThrowInvocationException();
        }

        public T Join() {
            m_reason.ThrowInvocationException();
            throw new Exception(); // unreachable code
        }

        public T Join(int timeout) {
            m_reason.ThrowInvocationException();
            throw new Exception(); // unreachable code
        }

        public void Then(IResolvable next) {
            next.Reject(m_reason);
        }

        public void Then(IResolvable<T> next) {
            next.Reject(m_reason);
        }
    }
}